% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDAZoom.R
\name{mlr_pipeops_fda.zoom}
\alias{mlr_pipeops_fda.zoom}
\alias{PipeOpFDAZoom}
\title{Zoom In/Out on Functional Columns}
\description{
Zoom in or out on functional features by restricting their domain to a specified window.
This operation extracts a subset of each function by defining new lower and upper boundaries,
effectively cropping the functional data to focus on a specific region of interest.
Calls \code{\link[tf:tf_zoom]{tf::tf_zoom()}} from package \CRANpkg{tf}.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{PipeOpTaskPreprocSimple}},
as well as the following parameters:
\itemize{
\item \code{begin} :: \code{numeric()}\cr
The lower limit of the domain. Can be a single value applied to all
functional columns, or a numeric of length equal to the number of observations.
The window includes all values where argument >= \code{begin}. If not specified,
defaults to the lower limit of each function's domain.
\item \code{end} :: \code{numeric()}\cr
The upper limit of the domain.
}
}

\examples{
task = tsk("fuel")
pop = po("fda.zoom", begin = 50, end = 100)
task_zoom = pop$train(list(task))[[1L]]
task_zoom$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDAZoom}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDAZoom-new}{\code{PipeOpFDAZoom$new()}}
\item \href{#method-PipeOpFDAZoom-clone}{\code{PipeOpFDAZoom$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAZoom-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAZoom-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAZoom$new(id = "fda.zoom", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default \code{"fda.zoom"}.}

\item{\code{param_vals}}{(named \code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAZoom-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAZoom-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAZoom$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
