% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDABsignal.R
\name{mlr_pipeops_fda.bsignal}
\alias{mlr_pipeops_fda.bsignal}
\alias{PipeOpFDABsignal}
\title{B-spline Feature Extraction}
\description{
This \code{PipeOp} extracts features from functional data using B-spline basis functions.
The extracted features are B-spline coefficients that represent the functional data in the B-spline basis space.
For more details, see \code{\link[FDboost:bsignal]{FDboost::bsignal()}}, which is called internally.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{PipeOpTaskPreprocSimple}},
as well as the following parameters:
\itemize{
\item \code{inS} :: \code{character(1)}\cr
Type of effect in the covariate index: one of \code{"smooth"}, \code{"linear"}, \code{"constant"}. Default \code{"smooth"}.
\item \code{knots} :: \code{numeric()}\cr
Either the number of interior knots or a vector of their positions.
\item \code{boundary.knots} :: \code{numeric(2)}\cr
Boundary points at which to anchor the B-spline basis.
Lower and upper boundary points for the spline basis. Defaults to the range of the data.
\item \code{degree} :: \code{integer(1)}\cr
The degree of the regression spline. Default is \code{3L}.
\item \code{differences} :: \code{integer(1)}\cr
Order of difference penalty. Default is \code{1L}.
\item \code{df} :: \code{numeric(1)}\cr
Trace of the hat matrix, controlling smoothness. Default is \code{4}.
\item \code{lambda} :: \code{any}\cr
Smoothing parameter of the penalty term.
\item \code{center} :: \code{logical(1)}\cr
Reparameterize the unpenalized part to zero-mean? Default is \code{FALSE}.
\item \code{cyclic} :: \code{logical(1)}\cr
If true the fitted coefficient function coincides at the boundaries.
\item \code{Z} :: \code{any}\cr
Custom transformation matrix for the spline design.
\item \code{penalty} :: \code{character(1)}\cr
The penalty type: \code{"ps"} (P-spline) or \code{"pss"} (shrinkage). DEfault is \code{"ps"}.
\item \code{check.ident} :: \code{logical(1)}\cr
Use checks for identifiability of the effect. Default is \code{FALSE}.
}
}

\examples{
task = tsk("fuel")
po_bsignal = po("fda.bsignal")
task_bsignal = po_bsignal$train(list(task))[[1L]]
task_bsignal$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDABsignal}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDABsignal-new}{\code{PipeOpFDABsignal$new()}}
\item \href{#method-PipeOpFDABsignal-clone}{\code{PipeOpFDABsignal$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDABsignal-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDABsignal-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDABsignal$new(id = "fda.bsignal", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default is \code{"fda.bsignal"}.}

\item{\code{param_vals}}{(named \code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDABsignal-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDABsignal-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDABsignal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
