% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{concat_outputs}
\alias{concat_outputs}
\title{Concatenate multiple outputs with multiple observations}
\usage{
concat_outputs(outputlist, centscal = "none")
}
\arguments{
\item{outputlist}{List of outputs. Each output is a \emph{n} x \emph{m}
matrix, where \emph{n} is the number of observations and \emph{m} is the
number of variables (i.e. output length).}

\item{centscal}{Centering and scaling method: "center", "auto", "range",
"iqrange", "vast", "pareto", "level" or "none". This task is delegated to the
\code{\link{centerscale}} function.}
}
\value{
An \emph{n} x \emph{p} matrix, representing the \emph{n} observations
of the concatenated output, each observation of length \emph{p}, which is the
sum of individual output lengths.
}
\description{
Concatenate multiple outputs with multiple observations.
}
\examples{

# Collect 20 observations of 3 outputs with different scales and lengths

# Output 1, length 100
out1 <- matrix(rnorm(2000, mean = 0, sd = 1), nrow = 20)

# Output 2, length 200
out2 <- matrix(rnorm(4000, mean = 100, sd = 200), nrow = 20)

# Output 1, length 50
out3 <- matrix(rnorm(1000, mean = -1000, sd = 10), nrow = 20)

# Concatenate and range scale outputs, resulting matrix dimensions will be
# 20 x 350
outconcat <- concat_outputs(list(out1, out2, out3), "range")
}
