% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypvolgmm.R
\name{hypvoltmvnorm}
\alias{hypvoltmvnorm}
\title{Approximate hypervolume for multivariate data}
\usage{
hypvoltmvnorm(data, radius = NULL, ...)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame. If a matrix or
data frame, rows correspond to observations and columns correspond
to variables. Categorical variables and missing values are not allowed.}

\item{radius}{A numerical value specifying the radius to be used for
truncating the multivariate Gaussian distribution. If not provided
is set to \eqn{sqrt(d+1)}, where \eqn{d} is the dimensionality of
the data, i.e. number of columns of \code{data}.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns a list with the following components:
\itemize{
\item \code{sigma} The estimated covariance matrix.
\item \code{radius} The radius used for computation.
\item \code{logvol} The log of hypervolume.
\item \code{logdens} The smallest log-density for observed data points within the
radius.
}
}
\description{
Approximate the hypervolume of a multivariate dataset by assuming
a truncated multivariate normal (TMVN) distribution within given radius.
}
\examples{
x1 = rnorm(1000)
x2 = 0.8*x1 + rnorm(1000)
x = cbind(x1, x2)
hypvoltmvnorm(x, radius = 1)

}
\author{
Luca Scrucca
}
