% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3DScene.R
\name{plot3DScene}
\alias{plot3DScene}
\title{multi-dimensional visualization of mating scene object}
\usage{
plot3DScene(
  scene,
  dimension = "auto",
  sub = NULL,
  N = 3,
  ycoord = "northing",
  xcoord = "easting",
  pch = 19,
  pt.cex = 0.7,
  label.cex = 0.7,
  mt1 = "F",
  mt2 = "M",
  plot.lim.zoom = FALSE,
  ...
)
}
\arguments{
\item{scene}{a matingScene object}

\item{dimension}{what dimension(s) of the mating scene should be visualized. Possible dimensions are 't' for temporal, 's' for spatial, 'mt' for mating type, and 'auto' (the default). For dimension = 'auto', all dimensions represented in the mating scene object will be plotted.}

\item{sub}{a subset of the population to plot; either a character indicating whether to subset a random sample (\code{sub}='random'), all individuals (\code{sub}='all'), or a vector containing the IDs of the individuals to subset.}

\item{N}{if \code{sub} = 'random', the number of individuals to sample (default N = 3)}

\item{ycoord}{y-axis coordinate system label}

\item{xcoord}{x-axis coordinate system label}

\item{pch}{point type, defaults to pch = 19, solid filled in circle. If pch = NULL, individuals will be labeled by their id.}

\item{pt.cex}{specify point expansion factor (point size relative to device default)}

\item{label.cex}{specify text expansion factor (text size relative to device default)}

\item{mt1}{label for mating type '1', if dioecious; defaults to 'F'}

\item{mt2}{label for mating type '2', if dioecious; defaults to 'M'}

\item{plot.lim.zoom}{if TRUE, spatial plot limits for lists of scenes are set by the maximum from all scenes}

\item{...}{optional arguments for the plot function}
}
\value{
No return value, called to draw a plot
}
\description{
Visualize multiple dimensions of a mating scene
}
\examples{
pop <- simulateScene()
plot3DScene(pop)



}
\seealso{
see generic function \code{graphics::\link[graphics]{points}()} for values of \code{pch}
}
\author{
Amy Waananen
}
