% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{add_stage}
\alias{add_stage}
\title{Add a New Stage to an Existing lefkoMat or lefkoMatList Object}
\usage{
add_stage(mpm, add_before = 0L, add_after = 0L, stage_name = NULL)
}
\arguments{
\item{mpm}{The \code{lefkoMat} or \code{lefkoMatList} object to add a stage
to.}

\item{add_before}{The index of the stage to insert a new stage before. This
index should be derived from the \code{ahstages} of the input \code{mpm}.
Cannot be set if \code{add_after} is to be used.}

\item{add_after}{The index of the stage to insert a new stage after. This
index should be derived from the \code{ahstages} of the input \code{mpm}.
Cannot be set if \code{add_before} is to be used.}

\item{stage_name}{The name of the new stage to add. Defaults to
\code{new_stage}.}
}
\value{
A new copy of the original MPM edited to include new rows and
columns in the associated matrices, and with \code{ahstages},
\code{agestages}, and \code{hstages} objects edited to include the new
stage.
}
\description{
Function \code{add_stage()} adds a new stage to an existing \code{lefkoMat}
or \code{lefkoMatList} object. In addition to altering the \code{ahstages}
object within the MPM, it alters the \code{hstages} and \code{agestages}
objects and adds the appropriate number of new rows and columns depending on
the kind of MPM input. Note that, if entering a \code{lefkoMatList} object,
then a stage will be added to all \code{lefkoMat} objects contained therein.
}
\examples{
data(cypdata)

cyp_lesl_data <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004, 
  patchidcol = "patch", individcol = "plantid", blocksize = 4, 
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04", 
  stagesize = "sizeadded", NAas0 = TRUE, age_offset = 2)

cyp_survival <- glm(alive3 ~ obsage + as.factor(year2), data = cyp_lesl_data,
  family = "binomial")
cyp_fecundity <- glm(feca2 ~ 1 + obsage + as.factor(year2),
  data = cyp_lesl_data, family = "poisson")

mod_params <- create_pm(name_terms = TRUE)
mod_params$modelparams[22] <- "obsage"

germination <- 0.08
protocorm_to_seedling <- 0.10
seeding_to_adult <- 0.20
seeds_per_fruit <- 8000

cyp_lesl_supp <- supplemental(historical = FALSE, stagebased = FALSE,
  agebased = TRUE, age2 = c(1, 2), type = c(1, 1),
  givenrate = c(protocorm_to_seedling, seeding_to_adult))

cyp_lesl_fb_mpm <- fleslie(data = cyp_lesl_data, surv_model = cyp_survival,
  fec_model = cyp_fecundity, paramnames = mod_params, last_age = 7,
  fecage_min = 3, fecmod = (germination * seeds_per_fruit),
  supplement = cyp_lesl_supp)

altered1 <- add_stage(cyp_lesl_fb_mpm, add_before = 1, stage_name = "DS")

}
\seealso{
\code{\link{edit_lM}()}
}
