% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad_array.R
\name{pad_array}
\alias{pad_array}
\title{Add padding to 3D array}
\usage{
pad_array(a, x = 0, y = 0, z = 0, fill = 0)
}
\arguments{
\item{a}{A 3-dimensional \code{\link[=array]{array}} of numeric values}

\item{x}{A positive or negative integer, denoting the number of rows to add
to the array. The sign dictates which side of the array to pad. Default is
zero.}

\item{y}{A positive or negative integer, denoting the number of columns to
add to the array. The sign dictates which side of the array to pad. Default
is zero.}

\item{z}{A positive or negative integer, denoting the number of "slices" to
add to the array. The sign dictates which side of the array to pad. Default
is zero.}

\item{fill}{The desired value to fill the array padding with. Default is
zero.}
}
\value{
A 3-dimensional \code{\link[=array]{array}} with the desired padding added.
The padded portions are labelled using their \code{\link[=dimnames]{dimnames}}. If
no padding has been specified, the function returns the original array.
}
\description{
\code{pad_array()} adds additional rows, columns, or slices to a 3-dimensional
array, increasing the array's dimensions by the desired amount and filling
the new space with a uniform value. It is intended for adding empty or
occupied space to the edges of a 3D spatial map.
}
\details{
\code{pad_array()} uses the signs of \code{x}, \code{y}, and \code{z} to determine where
to add padding. Negative values are prepended before the array's lower
indices (what one might call the "top", "front", or "beginning" of the
array), while positive values are appended after the upper indices (the
"bottom", "back", or "end" of the array).
}
\examples{
# generate array
a <- array(data = rep(c(1,0), 125), dim = c(5,5,5))
# add two rows of zeroes to top of array
pad <- pad_array(a, x = -2)
# add one row of zeroes to bottom of array, and two columns to beginning
pad <- pad_array(a, x = 1, y = -2)

}
