test_that("MB normalization scheme works", {
  input.matrix <- matrix(0:219, ncol = 20, dimnames = list(paste0("row_", 1:11), paste0("col_", 1:20)))

  output.matrix <- c(0, 0.331050228310502, 0.656479909451047, 0.976430976430977, 1.29104062326099, 1.60044150110375, 1.9047619047619, 2.20412595005429, 2.49865374259558, 2.78846153846154, 3.07366189719131, 1.29635273798639, 1.40209508460919, 1.50604214521123, 1.60823925529808, 1.70873023666896, 1.80755746007012, 1.9047619047619, 2.00038321517532, 2.09445975482277, 2.18702865761689, 2.27812587674179, 1.57414261041204, 1.63160469667319, 1.68809119573126, 1.74362674362674, 1.79823515382781, 1.8519394512772, 1.9047619047619, 1.95672405770126, 2.00784675744288, 2.05815018315018, 2.10765387235975, 1.69523050352066, 1.7316473480857, 1.76744591006051, 1.8026418026418, 1.83725011771756, 1.87128544744439, 1.9047619047619, 1.93769314290487, 1.9700923739696, 2.00197238658777, 2.03334556275733, 1.76303972366149, 1.78767123287671, 1.81188455008489, 1.83569023569024, 1.85909849749583, 1.88211920529801, 1.9047619047619, 1.92703583061889, 1.94894991922456, 1.97051282051282, 1.99173290937997, 1.80639315948923, 1.82348978216932, 1.84029613960867, 1.85681956173759, 1.8730671337475, 1.88904570622082, 1.9047619047619, 1.92022213915737, 1.93543261209248, 1.95039932744851, 1.96512809820428, 1.83649971214738, 1.84836377473364, 1.8600264101113, 1.87149270482604, 1.88276757558894, 1.89385577630611, 1.9047619047619, 1.91549040897575, 1.92604559325076, 1.93643162393162, 1.94665253488783, 1.85862621470337, 1.86664466083512, 1.87452697036022, 1.88227658107176, 1.88989681597844, 1.89739088805553, 1.9047619047619, 1.91201287233625, 1.91914669988516, 1.92616620327464, 1.93307410883598, 1.87557417410796, 1.88064704167881, 1.88563378246577, 1.89053657138764, 1.89535751074486, 1.90009863322531, 1.9047619047619, 1.90934922725068, 1.91386244113704, 1.9183033278778, 1.92267361228563, 1.88897113249445, 1.89171559034573, 1.89441345298731, 1.8970658970659, 1.89967405994117, 1.90223904131189, 1.9047619047619, 1.90724367923065, 1.90968536041234, 1.91208791208791, 1.91445226739344, 1.89982728842832, 1.90068493150685, 1.90152801358234, 1.9023569023569, 1.90317195325543, 1.90397350993377, 1.9047619047619, 1.90553745928339, 1.90630048465267, 1.90705128205128, 1.90779014308426, 1.9088028504209, 1.90810052852982, 1.90741013060973, 1.90673135555025, 1.90606391229477, 1.90540751942431, 1.9047619047619, 1.90412680499628, 1.9035019653238, 1.90288713910761, 1.90228208755305, 1.91634752571901, 1.91433392892595, 1.91235451883566, 1.91040843214756, 1.90849483438581, 1.90661291870621, 1.9047619047619, 1.90294103762451, 1.90114958675751, 1.89938684503902, 1.89765212783116, 1.92277822211404, 1.91964696147835, 1.91656886316245, 1.91354258468352, 1.91056682838288, 1.90764033957065, 1.9047619047619, 1.90193034999891, 1.8991445392547, 1.89640337291344, 1.89370578632324, 1.92832469775475, 1.92422945205479, 1.92020373514431, 1.91624579124579, 1.91235392320534, 1.90852649006623, 1.9047619047619, 1.90105863192182, 1.89741518578352, 1.89383012820513, 1.89030206677265, 1.93315759173408, 1.92822238244012, 1.92337096277763, 1.91860121684683, 1.91391109939568, 1.9092986328957, 1.9047619047619, 1.90029906470846, 1.89590832223261, 1.89158794421952, 1.88733625266133, 1.9374062897379, 1.93173265091073, 1.92615533871901, 1.92067192067192, 1.91528004549707, 1.90997743977876, 1.9047619047619, 1.8996313133121, 1.89458360702303, 1.88961679346295, 1.88472894355247, 1.94117068019723, 1.93484278515154, 1.9286223246567, 1.92250658571902, 1.91649294592888, 1.91057886971142, 1.9047619047619, 1.89903967865521, 1.89340989561971, 1.88787033346619, 1.88241884066328, 1.94452910697958, 1.93761751275853, 1.93082326309131, 1.92414339473163, 1.91757504337294, 1.9111154395533, 1.9047619047619, 1.89851184773584, 1.89236276093636, 1.88631221719457, 1.88035786651704, 1.94754388078885, 1.94010831474992, 1.93279898922099, 1.92561271631039, 1.91854641456691, 1.91159710457416, 1.9047619047619, 1.89803802742217, 1.89142277491829, 1.88491353607633, 1.87850778274855)
  output.matrix <- matrix(data = output.matrix, ncol = 20, dimnames = list(paste0("row_", 1:11), paste0("col_", 1:20)))

  expect_equal(
    object = .MBNormCounts(input.matrix),
    expected = output.matrix
  )
})

test_that("NA in normalization input triggers message", {

    #create Dummy object and add NA
    tap.object <- suppressMessages(newDummyTapestriExperiment())
    x <- assay(tap.object)
    x[1,1] <- NA
    assay(tap.object) <- x

    expect_warning(calcNormCounts(tap.object), "NAs found in count data.")

})
