% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{runClustering}
\alias{runClustering}
\title{Cluster 2D data}
\usage{
runClustering(
  TapestriExperiment,
  alt.exp = "alleleFrequency",
  dim.reduction = "UMAP",
  eps = 0.8,
  dim.1 = 1,
  dim.2 = 2,
  ...
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} slot to use. \code{NULL} uses top-level/main experiment. Default "alleleFrequency".}

\item{dim.reduction}{Character, reduced dimension data to use. Default "UMAP".}

\item{eps}{Numeric, \code{dbscan} \code{eps} parameter. Lower to increase cluster granularity. See \code{\link[dbscan:dbscan]{dbscan::dbscan()}}. Default 0.8.}

\item{dim.1}{Numeric, index of data dimension to use. Default 1.}

\item{dim.2}{Numeric, index of data dimension to use. Default 2.}

\item{...}{Additional parameters to pass to \code{\link[dbscan:dbscan]{dbscan::dbscan()}}.}
}
\value{
\code{TapestriExperiment} object with updated \code{colData} containing cluster assignments.
}
\description{
Clusters data using dbscan method and saves cluster assignments for each cell barcode to \code{colData}.
Generally used to assign clusters to UMAP projection after PCA and UMAP dimensional reduction.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- runPCA(tap.object, alt.exp = "alleleFrequency")
tap.object <- runUMAP(tap.object, pca.dims = 1:3)
tap.object <- runClustering(tap.object, dim.reduction = "UMAP", eps = 0.8)
}
\seealso{
\code{\link[dbscan:dbscan]{dbscan::dbscan()}}
}
\concept{dimensional reduction}
