% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{PCAKneePlot}
\alias{PCAKneePlot}
\title{Plot of PCA proportion of variance explained}
\usage{
PCAKneePlot(TapestriExperiment, alt.exp = "alleleFrequency", n.pcs = 10)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} to use, \code{NULL} uses top-level/main experiment. Default "alleleFrequency".}

\item{n.pcs}{Numeric, number of PCs to plot, starting at 1. Default 10.}
}
\value{
ggplot2 object, combined line plot and bar graph
}
\description{
Draws "knee plot" of PCA proportion of variance explained to determine which principal components (PCs) to include for downstream applications e.g. clustering.
Variance explained for each PC is indicated by the line.
Cumulative variance explained is indicated by the bars.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- runPCA(tap.object, alt.exp = "alleleFrequency")
PCAKneePlot(tap.object, n.pcs = 5)
}
\concept{dimensional reduction}
\concept{plots}
