% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_transpose.R
\name{vector_transpose_longer}
\alias{vector_transpose_longer}
\alias{vector_transpose}
\title{Transpose a Vector to Long Form}
\usage{
vector_transpose_longer(
  data_table,
  names_to = "nace_r2",
  values_to = "value",
  key_column_name = NULL,
  .keep = FALSE
)

vector_transpose(
  data_table,
  names_to = "nace_r2",
  values_to = "value",
  key_column_name = NULL,
  .keep = FALSE
)
}
\arguments{
\item{data_table}{A \code{data.frame} or tibble. The first column is assumed to
be a key column.}

\item{names_to}{Name of the new column containing previous column names.
Default: \code{"nace_r2"}.}

\item{values_to}{Name of the new column containing the values. Default:
\code{"value"}.}

\item{key_column_name}{Optional. New name for the first (key) column. If
\code{NULL} (default), the name is not changed.}

\item{.keep}{Logical. If \code{TRUE}, keep the indicator identifier column. If
\code{FALSE} (default), drop it.}
}
\value{
A tibble in long format with a key column and, if requested, the
indicator identifier column.
}
\description{
Convert a wide-form vector (e.g., indicators or multipliers) into long form,
which is often more useful for printing or joining. This is a thin wrapper
around \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}, provided so you do not need to load \strong{tidyr}
explicitly.
}
\examples{
vector_transpose_longer(
  data.frame(
    indicator = "my_indicator",
    agriculture = 0.0123,
    manufacturing = 0.1436,
    trade = 0.0921
  )
)

# Keep the indicator column
vector_transpose_longer(
  data.frame(
    indicator = "my_indicator",
    agriculture = 0.0123,
    manufacturing = 0.1436
  ),
  .keep = TRUE
)
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
