% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leontief_inverse_create.R
\name{leontief_inverse_create}
\alias{leontief_inverse_create}
\alias{leontieff_inverse_create}
\title{Create the Leontief inverse}
\usage{
leontief_inverse_create(technology_coefficients_matrix, digits = NULL)

leontieff_inverse_create(technology_coefficients_matrix, digits = NULL)
}
\arguments{
\item{technology_coefficients_matrix}{A technology-coefficient matrix created
by \code{\link[=input_coefficient_matrix_create]{input_coefficient_matrix_create()}}.}

\item{digits}{Optional integer. Precision for rounding. Default \code{NULL}
(no rounding).}
}
\value{
A \code{data.frame} with the original key column and the Leontief inverse in the
remaining columns. If \code{digits} is provided, values are rounded.
}
\description{
Compute the Leontief inverse from a technology-coefficient matrix.
}
\details{
The Leontief inverse is defined as
\eqn{L = (I - A)^{-1}},
where \eqn{A} is the input-coefficient matrix created by
\code{\link[=input_coefficient_matrix_create]{input_coefficient_matrix_create()}}.

In the Eurostat \emph{Manual of Supply, Use and Input–Output Tables} (Beutel, 2008),
this formulation appears in Chapter 15 (see equations (19), (43), etc.).
The UN \emph{Handbook on Supply and Use Tables and Input–Output Tables with Extensions
and Applications} (2018, Rev. 1) also uses this standard definition (see pp. 619–621).

For the analogous inverse from output coefficients, see \code{\link[=ghosh_inverse_create]{ghosh_inverse_create()}}.
}
\examples{
# A tiny 2x2 system with hand-calculable inverse
minimal_matrix <- data.frame(
  sector = c("A", "B"),
  A = c(0.2, 0.4),
  B = c(0.1, 0.2)
)

leontief_inverse_create(minimal_matrix, digits = 3)

# With a full example from the package
tm <- input_flow_get(
  data_table = iotable_get(),
  households = FALSE
)
leontief_inverse_create(technology_coefficients_matrix = tm)

}
\seealso{
Other analytic object functions: 
\code{\link{ghosh_inverse_create}()},
\code{\link{input_flow_get}()},
\code{\link{leontief_matrix_create}()},
\code{\link{output_coefficient_matrix_create}()}
}
\concept{analytic object functions}
