% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_iimi.R
\name{predict_iimi}
\alias{predict_iimi}
\title{predict_iimi()}
\usage{
predict_iimi(newdata, method = "xgb", trained_model, report_virus_level = TRUE)
}
\arguments{
\item{newdata}{A matrix or data frame that contains the features extracted
from the coverage profile using \code{convert_bam_to_cov()}.}

\item{method}{The machine learning method of choice, \code{rf},
\code{xgb}, or \code{en}. \code{rf} stands for random forest model; \code{xgb} stands for
XGBoost model; and \code{en} stands for elastic net model.}

\item{trained_model}{The trained model. If not provided, default model is
used.}

\item{report_virus_level}{If \code{TRUE}, the function returns the aggregated
results based on the virus. If \code{FALSE}, the function returns the
unaggregated results based on segment level with each decision's
probability decided by the model. We do not recommended to set this to
\code{FALSE}.}
}
\value{
A data frame of diagnostics result for each sample
}
\description{
Uses a machine learning model to predict the infection status
for the plant sample(s). User can use their own model if needed.
}
\examples{

\dontrun{df <- convert_rle_to_df(example_cov)
predictions <- predict_iimi(df)
}



}
