% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_rle_to_df.R
\name{convert_rle_to_df}
\alias{convert_rle_to_df}
\title{Convert run-length encodings (RLEs) to a data frame.}
\usage{
convert_rle_to_df(
  covs,
  unreliable_region_version = "1_4_0",
  unreliable_region_enabled = TRUE,
  additional_nucleotide_info = data.frame()
)
}
\arguments{
\item{covs}{A list of Coverage profile(s) in RLE format. Can be one or more
samples.}

\item{unreliable_region_version}{The version number (character string) of unreliable regions of the virus segments.
Default is \verb{1_4_0}. It includes the mappability profile from
a host genome (we only have Arabidopsis thaliana right now) and virus
references, and the regions that have CG\% and A\% over 60\% and 45\%
respectively.}

\item{unreliable_region_enabled}{Default is \code{TRUE}. If \code{TRUE}, the input will be
checked against \code{unreliable_region_df}. If \code{FALSE}, this step will be
skipped.}

\item{additional_nucleotide_info}{Additional nucleotide information for virus
segments that are not included in \code{nucleotide_info}. The information
provided must be a data frame that follows the format of
\code{nucleotide_info}. Default is an empty data frame.}
}
\value{
A data frame object that contains the mapping result for each virus
segment that the plant sample reads are aligned to and a RLE list of
coverage information.
}
\description{
Converts a list of run-length encodings (RLEs) into a data frame
with 16 features after mappability profiling and nucleotide filtering.
}
\details{
Converts a list of run-length encodings (RLEs) into a data frame.

The returned dataframe contains 16 features for training a machine learning model.
after mappability profiling and nucleotide filtering.
}
\examples{
\dontrun{
df <- convert_rle_to_df(example_cov)
}

}
