% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_heart.R
\name{pulse_heart}
\alias{pulse_heart}
\title{(\verb{STEP 4}) Determine the heartbeat rate in all channels of a split PULSE object}
\usage{
pulse_heart(pulse_data_split, msg = TRUE, show_progress = FALSE)
}
\arguments{
\item{pulse_data_split}{the output from a call to \code{\link[=pulse_split]{pulse_split()}}}

\item{msg}{logical, defaults to \code{TRUE}; should non-crucial messages (but not errors) be shown (mostly for use from within the wrapper function \code{PULSE()}, where it is set to \code{FALSE} to avoid the repetition of identical messages)}

\item{show_progress}{logical, defaults to \code{FALSE}. If set to \code{TRUE}, progress messages will be provided.}
}
\value{
A tibble with nrows = (number of channels) * (number of windows in \code{pulse_data_split}) and 10 columns:
\itemize{
\item \code{i}, index of each time window's order
\item \code{smoothed}, whether the data has been smoothed with \code{\link[=pulse_smooth]{pulse_smooth()}}
\item \code{id}, PULSE channel IDs
\item \code{time}, time at the center of each time window
\item \code{data}, a list of tibbles with raw PULSE data for each combination of channel and window, with columns \code{time}, \code{val} and \code{peak} (\code{TRUE} in rows corresponding to wave peaks)
\item \code{hz},  heartbeat rate estimate (in Hz)
\item \code{n},   number of wave peaks identified
\item \code{sd},  standard deviation of the intervals between wave peaks
\item \code{ci},  confidence interval (hz ± ci)
\item \code{keep}, whether \code{n} and \code{sd} are within the target thresholds
}
}
\description{
\itemize{
\item \verb{step 1} -- \code{\link[=pulse_read]{pulse_read()}}
\item \verb{step 2} -- \code{\link[=pulse_split]{pulse_split()}}
\item \verb{step 3} -- \code{\link[=pulse_optimize]{pulse_optimize()}}
\item \strong{\verb{-->>} step 4 -- \code{\link[=pulse_heart]{pulse_heart()}} \verb{<<--}}
\item \verb{step 5} -- \code{\link[=pulse_doublecheck]{pulse_doublecheck()}}
\item \verb{step 6} -- \code{\link[=pulse_choose_keep]{pulse_choose_keep()}}
}

For each combination of channel and time window, determine the heartbeat rate automatically.

\code{pulse_heart()} takes the output from a call to \code{pulse_optimize()} (or \code{pulse_split()} if optimization is skipped, but that is highly discouraged) and employs an algorithm optimized for the identification of wave peaks in noisy data to determine the heart beat frequency in all channels of the PULSE dataset.
}
\section{BPM}{

To convert to Beats Per Minute, simply multiply \code{hz} and \code{ci} by 60.
}

\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:3]
pulse_data_split <- pulse_split(pulse_data_sub)
pulse_data_split <- pulse_optimize(pulse_data_split, multi = pulse_data$multi)
## End prepare data ----

# Determine heartbeat rates in all channels in all time window
pulse_heart(pulse_data_split)
}
\seealso{
\itemize{
\item \code{\link[=pulse_find_peaks_all_channels]{pulse_find_peaks_all_channels()}} runs \code{\link[=pulse_find_peaks_one_channel]{pulse_find_peaks_one_channel()}} on all PULSE channels
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
\item \code{\link[=pulse_summarise]{pulse_summarise()}} can be used to reduce the number of data points returned
}
}
