/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5TSmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5TSpkg.h"    

#ifdef H5_HAVE_THREADS

#ifdef H5_HAVE_C11_THREADS

herr_t
H5TS_once(H5TS_once_t *once, H5TS_once_init_func_t func)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    if (H5_UNLIKELY(NULL == once || NULL == func))
        HGOTO_DONE(FAIL);

    
    call_once(once, func);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 
#else
#ifdef H5_HAVE_WIN_THREADS

herr_t
H5TS_once(H5TS_once_t *once, H5TS_once_init_func_t func)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    if (H5_UNLIKELY(NULL == once || NULL == func))
        HGOTO_DONE(FAIL);

    
    if (H5_UNLIKELY(0 == InitOnceExecuteOnce(once, func, NULL, NULL)))
        HGOTO_DONE(FAIL);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 
#else

herr_t
H5TS_once(H5TS_once_t *once, H5TS_once_init_func_t func)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    if (H5_UNLIKELY(NULL == once || NULL == func))
        HGOTO_DONE(FAIL);

    
    if (H5_UNLIKELY(pthread_once(once, func)))
        HGOTO_DONE(FAIL);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 
#endif
#endif

#endif 
