% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usgsdv.R
\name{get_usgs_dv_interactively}
\alias{get_usgs_dv_interactively}
\title{Get United States Geologic Survey (USGS) Daily Flow Values Interactively}
\usage{
get_usgs_dv_interactively(
  ns = "usgsdv-ui",
  viewer = shiny::paneViewer(),
  title = "Get USGS Daily Flow Values",
  ...
)
}
\arguments{
\item{ns}{\code{string} name for the Shiny \code{namespace} to use.  The \code{ns}
is unlikely to require a change.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{title}{\code{string} to customize the title of the UI window.  The default
is "Get USGS Instantaneous Flow Values".}

\item{...}{other arguments to \code{leafletOutput()} in module.}
}
\value{
A data.frame that contains flow values based on the station(s) selected
during shiny session.
}
\description{
This function allows the user to select United States Geologic Survey (USGS) stations
and get back daily flow values based on station selected. It uses the USGS
Water Services to get the values as well as the USGS Sites.
}
\details{
\strong{Steps}
\enumerate{
\item Select the sites you want to retrieve.
\item When finished, press 'done' and sites daily flow values will be saved to
a data.frame in local environment.
}
}
\note{
You can select multiple stations. The information from the \code{hover} details is not included in
the data.frame that is returned, e.g. rate of change, percentile description.
}
\examples{

if(interactive()){
dv_usgs <- get_usgs_dv_interactively()
}



}
