% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_p_footnotes.R
\name{separate_p_footnotes}
\alias{separate_p_footnotes}
\title{Create footnotes for individual p-values}
\usage{
separate_p_footnotes(x)
}
\arguments{
\item{x}{(\code{tbl_summary}, \code{tbl_svysummary})\cr
Object with class \code{"tbl_summary"} or \code{"tbl_svysummary"}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}\cr
The usual presentation of footnotes for p-values on a gtsummary table is
to have a single footnote that lists all statistical tests that were used to
compute p-values on a given table. The \code{separate_p_footnotes()} function
separates aggregated p-value footnotes to individual footnotes that denote
the specific test used for each of the p-values.
}
\examples{
# Example 1 ----------------------------------
trial |>
  tbl_summary(by = trt, include = c(age, grade)) |>
  add_p() |>
  separate_p_footnotes()
}
