% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.gtsummary}
\alias{inline_text.gtsummary}
\title{Report statistics from summary tables inline}
\usage{
\method{inline_text}{gtsummary}(x, variable, level = NULL, column = NULL, pattern = NULL, ...)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
gtsummary object}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single variable name of statistic to present}

\item{level}{(\code{string})\cr
Level of the variable to display for categorical variables.
Default is \code{NULL}}

\item{column}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Column name to return from \code{x$table_body}.}

\item{pattern}{(\code{string})\cr
String indicating the statistics to return.
Uses \code{\link[glue:glue]{glue::glue()}} formatting. Default is \code{NULL}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A string
}
\description{
Report statistics from summary tables inline
}
\section{column + pattern}{


Some gtsummary tables report multiple statistics in a single cell,
e.g. \code{"{mean} ({sd})"} in \code{tbl_summary()} or \code{tbl_svysummary()}.
We often need to report just the mean or the SD, and that can be accomplished
by using both the \verb{column=} and \verb{pattern=} arguments. When both of these
arguments are specified, the column argument selects the column to report
statistics from, and the pattern argument specifies which statistics to report,
e.g. \code{inline_text(x, column = "stat_1", pattern = "{mean}")} reports just the
mean from a \code{tbl_summary()}. \emph{This is not supported for all tables.}
}

