% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_summary_type.R
\name{assign_summary_type}
\alias{assign_summary_type}
\title{Assign Default Summary Type}
\usage{
assign_summary_type(data, variables, value, type = NULL, cat_threshold = 10L)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{character})\cr
character vector of column names in \code{data}}

\item{value}{(\verb{named list})\cr
named list of values to show for dichotomous variables, where
the names are the variables}

\item{type}{(\verb{named list})\cr
named list of summary types, where names are the variables}

\item{cat_threshold}{(\code{integer})\cr
for base R numeric classes with fewer levels than
this threshold will default to a categorical summary. Default is \code{10L}}
}
\value{
named list
}
\description{
Function inspects data and assigns a summary type when not specified
in the \code{type} argument.
}
\examples{
assign_summary_type(
  data = trial,
  variables = c("age", "grade", "response"),
  value = NULL
)
}
