% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_difference_row.R
\name{add_difference_row.tbl_summary}
\alias{add_difference_row.tbl_summary}
\title{Add differences rows between groups}
\usage{
\method{add_difference_row}{tbl_summary}(
  x,
  reference,
  statistic = everything() ~ "{estimate}",
  test = NULL,
  group = NULL,
  header = NULL,
  adj.vars = NULL,
  test.args = NULL,
  conf.level = 0.95,
  include = everything(),
  pvalue_fun = label_style_pvalue(digits = 1),
  estimate_fun = list(c(all_continuous(), all_categorical(FALSE)) ~ label_style_sigfig(),
    all_dichotomous() ~ label_style_sigfig(scale = 100, suffix = "\%"), all_tests("smd")
    ~ label_style_sigfig()),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
table created with \code{tbl_summary()}}

\item{reference}{(scalar)\cr
Value of the \code{tbl_summary(by)} variable value that is the reference for
each of the difference calculations. For factors, use the character
level.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies summary statistics to display for each variable.  The default is
\code{everything() ~ "{estimate}"}. The statistics available to include will
depend on the method specified in the \code{test} argument, but are generally
\code{"estimate"}, \code{"std.error"}, \code{"parameter"}, \code{"statistic"},
\code{"conf.low"}, \code{"conf.high"}, \code{"p.value"}.}

\item{test}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the tests/methods to perform for each variable, e.g.
\code{list(all_continuous() ~ "t.test", all_dichotomous() ~ "prop.test", all_categorical(FALSE) ~ "smd")}.

See below for details on default tests and \link[=tests]{?tests} for details on available
tests and creating custom tests.}

\item{group}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable name of an ID or grouping variable. The column can be used to
calculate p-values with correlated data.
Default is \code{NULL}. See \link{tests} for methods that utilize the \code{group} argument.}

\item{header}{(\code{string})\cr
When supplied, a header row will appear above the difference statistics.}

\item{adj.vars}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in adjusted calculations (e.g. in ANCOVA models).
Default is \code{NULL}.}

\item{test.args}{(\code{\link[=syntax]{formula-list-selector}})\cr
Containing additional arguments to pass to tests that accept arguments.
For example, add an argument for all t-tests, use
\code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}.}

\item{conf.level}{(\code{numeric})\cr
a scalar in the interval \verb{(0, 1)} indicating the confidence level. Default is 0.95}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{estimate_fun}{(\code{\link[=syntax]{formula-list-selector}})\cr
List of formulas specifying the functions
to round and format differences and confidence limits.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table of class \code{"tbl_summary"}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Adds difference to tables created by \code{\link[=tbl_summary]{tbl_summary()}} as additional rows.
This function is often useful when there are more than two groups to compare.

Pairwise differences are calculated relative to the specified
\code{by} variable's specified reference level.
}
\details{
The default labels for the statistic rows will often \emph{not} be what you need
to display. In cases like this, use \code{modify_table_body()} to directly
update the label rows. Use \code{show_header_names()} to print the underlying
column names to identify the columns to target when changing the label,
which in this case will always be the \code{'label'} column.
See Example 2.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("broom", ref = "cardx")) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  tbl_summary(
    by = grade,
    include = c(age, response),
    missing = "no",
    statistic = all_continuous() ~ "{mean} ({sd})"
  ) |>
  add_stat_label() |>
  add_difference_row(
    reference = "I",
    statistic = everything() ~ c("{estimate}", "{conf.low}, {conf.high}", "{p.value}")
  )

# Example 2 ----------------------------------
# Function to build age-adjusted logistic regression and put results in ARD format
ard_odds_ratio <- \(data, variable, by, ...) {
  cardx::construct_model(
    data = data,
    formula = reformulate(response = variable, termlabels = c(by, "age")), # adjusting model for age
    method = "glm",
    method.args = list(family = binomial)
  ) |>
    cardx::ard_regression_basic(exponentiate = TRUE) |>
    dplyr::filter(.data$variable == .env$by)
}

trial |>
  tbl_summary(by = trt, include = response, missing = "no") |>
  add_stat_label() |>
  add_difference_row(
    reference = "Drug A",
    statistic = everything() ~ c("{estimate}", "{conf.low}, {conf.high}", "{p.value}"),
    test = everything() ~ ard_odds_ratio,
    estimate_fun = everything() ~ label_style_ratio()
  ) |>
  # change the default label for the 'Odds Ratio'
  modify_table_body(
    ~ .x |>
      dplyr::mutate(
        label = ifelse(label == "Coefficient", "Odds Ratio", label)
      )
  ) |>
  # add footnote about logistic regression
  modify_footnote_body(
    footnote = "Age-adjusted logistic regression model",
    column = "label",
    rows = variable == "response-row_difference"
  )
\dontshow{\}) # examplesIf}
}
