% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_autofit.R
\name{range_autofit}
\alias{range_autofit}
\title{Auto-fit columns or rows to the data}
\usage{
range_autofit(ss, sheet = NULL, range = NULL, dimension = c("columns", "rows"))
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:drive_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to modify, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number. Ignored if the sheet is specified via \code{range}. If neither argument specifies the sheet, defaults to the first visible sheet.}

\item{range}{Which columns or rows to resize. Optional. If you want to resize
all columns or all rows, use \code{dimension} instead. All the usual \code{range}
specifications are accepted, but the targeted range must specify only
columns (e.g. "B:F") or only rows (e.g. "2:7").}

\item{dimension}{Ignored if \code{range} is given. If consulted, \code{dimension} must
be either \code{"columns"} (the default) or \code{"rows"}. This is the simplest way
to request auto-resize for all columns or all rows.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Applies automatic resizing to either columns or rows of a (work)sheet. The
width or height of targeted columns or rows, respectively, is determined
from the current cell contents. This only affects the appearance of a sheet
in the browser and doesn't affect its values or dimensions in any way.
}
\examples{
\dontshow{if (gs4_has_token()) withAutoprint(\{ # examplesIf}
dat <- tibble::tibble(
  fruit = c("date", "lime", "pear", "plum")
)

ss <- gs4_create("range-autofit-demo", sheets = dat)
ss

# open in the browser
gs4_browse(ss)

# shrink column A to fit the short fruit names
range_autofit(ss)
# in the browser, notice how the column width shrank

# send some longer fruit names
dat2 <- tibble::tibble(
  fruit = c("cucumber", "honeydew")
)
ss \%>\% sheet_append(dat2)
# in the browser, see that column A is now too narrow to show the data

range_autofit(ss)
# in the browser, see the column A reveals all the data now

# clean up
gs4_find("range-autofit-demo") \%>\%
  googledrive::drive_trash()
\dontshow{\}) # examplesIf}
}
\seealso{
Makes an \code{AutoResizeDimensionsRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#autoresizedimensionsrequest}
}
}
\concept{formatting functions}
