% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_download.R
\name{drive_download}
\alias{drive_download}
\title{Download a Drive file}
\usage{
drive_download(
  file,
  path = NULL,
  type = NULL,
  overwrite = FALSE,
  verbose = deprecated()
)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with \code{\link[=as_id]{as_id()}}, or a
\code{\link{dribble}}.}

\item{path}{Character. Path for output file. If absent, the default file name
is the file's name on Google Drive and the default location is working
directory, possibly with an added file extension.}

\item{type}{Character. Only consulted if \code{file} is a native Google file.
Specifies the desired type of the exported file. Will be processed via
\code{\link[=drive_mime_type]{drive_mime_type()}}, so either a file extension like \code{"pdf"} or a full MIME
type like \code{"application/pdf"} is acceptable.}

\item{overwrite}{A logical scalar. If local \code{path} already exists, do you
want to overwrite it?}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This logical argument to
individual googledrive functions is deprecated. To globally suppress
googledrive messaging, use \code{options(googledrive_quiet = TRUE)} (the default
behaviour is to emit informational messages). To suppress messaging in a
more limited way, use the helpers \code{\link[=local_drive_quiet]{local_drive_quiet()}} or
\code{\link[=with_drive_quiet]{with_drive_quiet()}}.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per file.
}
\description{
This function downloads a file from Google Drive. Native Google
file types, such as Google Docs, Google Sheets, and Google Slides, must be
exported to a conventional local file type. This can be specified:
\itemize{
\item explicitly via \code{type}
\item implicitly via the file extension of \code{path}
\item not at all, i.e. rely on the built-in default
}

To see what export file types are even possible, see the \href{https://developers.google.com/drive/api/v3/ref-export-formats}{Drive API documentation}
or the result of \code{drive_about()$exportFormats}. The returned dribble
includes a \code{local_path} column.
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
# Target one of the official example files
(src_file <- drive_example_remote("chicken_sheet"))

# Download Sheet as csv, explicit type
downloaded_file <- drive_download(src_file, type = "csv")

# See local path to new file
downloaded_file$local_path

# Download as csv, type implicit in file extension
drive_download(src_file, path = "my_csv_file.csv")

# Download with default name and type (xlsx)
drive_download(src_file)

# Clean up
unlink(c("chicken_sheet.csv", "chicken_sheet.xlsx", "my_csv_file.csv"))
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://developers.google.com/drive/api/v3/manage-downloads}{Download files}, in the
Drive API documentation.
}
