% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_absences.R
\name{generate_pa_env_space_flexsdm}
\alias{generate_pa_env_space_flexsdm}
\title{Generate Environmental-space Pseudo-Absences via flexsdm (per temporal stratum)}
\usage{
generate_pa_env_space_flexsdm(
  presences,
  raster_stack,
  predictor_variables,
  coords = c("decimalLongitude", "decimalLatitude"),
  ratio = 1,
  attempts = 100,
  seed = NULL
)
}
\arguments{
\item{presences}{Data frame containing presence points.}

\item{raster_stack}{`SpatRaster` object containing covariate data. Uses continuous predictor only and samples per timestamp.}

\item{predictor_variables}{Character vector of the predictor variables selected for this species.}

\item{coords}{Character vector specifying the column names for latitude and longitude. Defaults to `c("decimalLongitude", "decimalLatitude")`.}

\item{ratio}{Ratio of pseudo-absences to presences (default 1 = balanced).}

\item{attempts}{Integer specifying the number of attempts to generate exact pseudo-absences. Defaults to 100.}

\item{seed}{Optional seed for reproducibility.}
}
\value{
A data frame of pseudo-absences with coordinates, timestamp, `pa = 0`, and covariate values.
}
\description{
Uses flexsdm::sample_pseudoabs(method = c("env_const", env = predictors) within each timestamp stratum so that
pseudo-absences match the temporal distribution of presences. Extracts covariate values
for the sampled coordinates and returns a data.frame with the same predictor columns.
}
