% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/channels.R
\name{Channels}
\alias{Channels}
\alias{ch_red}
\alias{ch_green}
\alias{ch_blue}
\alias{ch_alpha}
\alias{ch_hue}
\alias{ch_chroma}
\alias{ch_luminance}
\alias{ch_saturation}
\alias{ch_lightness}
\alias{ch_cyan}
\alias{ch_magenta}
\alias{ch_yellow}
\alias{ch_black}
\alias{ch_key}
\alias{ch_custom}
\title{Set a channel of interest from a layer}
\usage{
ch_red(x, colourspace = "sRGB", invert = FALSE)

ch_green(x, colourspace = "sRGB", invert = FALSE)

ch_blue(x, colourspace = "sRGB", invert = FALSE)

ch_alpha(x, colourspace = "sRGB", invert = FALSE)

ch_hue(x, colourspace = "HCL", invert = FALSE)

ch_chroma(x, colourspace = "HCL", invert = FALSE)

ch_luminance(x, colourspace = "HCL", invert = FALSE)

ch_saturation(x, colourspace = "HSL", invert = FALSE)

ch_lightness(x, colourspace = "HSL", invert = FALSE)

ch_cyan(x, colourspace = "CMYK", invert = FALSE)

ch_magenta(x, colourspace = "CMYK", invert = FALSE)

ch_yellow(x, colourspace = "CMYK", invert = FALSE)

ch_black(x, colourspace = "CMYK", invert = FALSE)

ch_key(x, colourspace = "CMYK", invert = FALSE)

ch_custom(x, channel, colourspace, invert = FALSE)
}
\arguments{
\item{x}{Any object interpretable as a layer}

\item{colourspace}{The colourspace the channel should be extracted from.}

\item{invert}{Should the channel values be inverted before use}

\item{channel}{The name of a channel in the given colourspace}
}
\value{
\code{x} with a channel spec attached
}
\description{
Some effects uses a particular channel for specific parameters, such as
\code{\link[=with_displacement]{with_displacement()}}, which grabs the relative x and y displacements from
different channels in some other layer. To facilitate specifying which
channel to use from a layer (which is always multichannel), you can wrap the
specification in a channel specifier given below. If a filter requires a
specific channel and none is specified it will default to \code{luminance} (based
on the \code{hcl} colour space)
}
\examples{
library(ggplot2)
volcano_long <- data.frame(
  x = as.vector(col(volcano)),
  y  = as.vector(row(volcano)),
  z = as.vector(volcano)
)

# invert the green channel
ggplot(volcano_long, aes(y, x)) +
  as_reference(
    geom_contour_filled(aes(z = z, fill = after_stat(level))),
    id = 'contours'
  ) +
  as_colourspace(
    ch_red('contours'),
    ch_green('contours', invert = TRUE),
    ch_blue('contours')
  )

}
