% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_points.R
\name{point_distance}
\alias{point_distance}
\title{Distance Between Points}
\usage{
point_distance(a, b, ...)
}
\arguments{
\item{a}{lon, lat coordinate of point 1}

\item{b}{lon, lat coordinate of point 2}

\item{...}{parameters passed to \code{\link[tectonicr:dist_greatcircle]{tectonicr::dist_greatcircle()}}}
}
\value{
units object giving the distance
}
\description{
This uses the \strong{haversine} formula (by default) to calculate
the great-circle distance between two points, i.e., the shortest distance
over the earth's surface.
}
\examples{
berlin <- c(13.4, 52.517) # lon, lat
tokyo <- c(139.767, 35.7) # lon, lat
point_distance(berlin, tokyo)
}
