% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{block_tidydesign}
\alias{block_tidydesign}
\title{Turn tidydesign into block format}
\usage{
block_tidydesign(
  tidydesign,
  collapse = NULL,
  wellnames_sep = "_",
  wellnames_colname = "Well"
)
}
\arguments{
\item{tidydesign}{A tidydesign data.frame (e.g. as created by make_tidydesign)}

\item{collapse}{NULL or a string to use for concatenating design elements
together. If NULL each design column will be put into its
own block. If a string, that string will be used to \link{paste}
together all design elements and all design elements will
be returned in a single block}

\item{wellnames_sep}{A string used when concatenating rownames and column
names to create well names}

\item{wellnames_colname}{Header for newly-created column containing the
well names}
}
\value{
A list of blockdesign data.frames (if \code{collapse} is not
        \code{NULL} the list is of length 1
}
\description{
This function allows users to convert designs created with tidydesign
 into a block format for easy output to csv for inclusion in lab notebooks,
 etc in a human-readable format
}
