% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_cluster.R
\name{gc_cluster}
\alias{gc_cluster}
\title{Identify Breakpoints of Gene Clusters within a Contig}
\usage{
gc_cluster(Data = orf_position.tmp, AllGeneNum = 30, MinConSeq = 15)
}
\arguments{
\item{Data}{A numeric vector (ascending order) of ORF positions that carry
one of the reference genes of interest.  Usually the vector
\code{orf_position.tmp} created inside \code{gc_cal}.}

\item{AllGeneNum}{Integer.  Maximum genomic span (in ORF count) that the
algorithm is allowed to cover when defining a single
cluster.  Passed unchanged from \code{gc_cal}.}

\item{MinConSeq}{Integer.  Minimum number of consecutive reference genes
required to form a cluster.  Passed unchanged from
\code{gc_cal}.}
}
\value{
A numeric vector containing every position that marks the \strong{end}
of a putative gene cluster.  These values are subsequently used as
breakpoints to slice the contig into candidate regions in the
downstream functions \code{gc_position()} and \code{gc_range()}.
}
\description{
Internal helper used by \code{\link{gc_cal}}.
Given the ordered positions of \emph{reference} genes on a contig,
this function returns the genomic coordinates that mark the
boundary of each candidate cluster.
A boundary is declared whenever the gap between two successive
reference genes exceeds the maximum spacing allowed by the
cluster definition (\code{AllGeneNum - MinConSeq}).
}
\details{
\itemize{
\item If the gap between two consecutive reference genes is larger than
\code{AllGeneNum - MinConSeq}, the left-hand gene is recorded as the
\strong{last member} of the preceding cluster.
\item The final reference gene is always appended to the vector as the last
boundary, ensuring the rightmost cluster is not lost.
}
}
