% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{shd}
\alias{shd}
\title{Structural Hamming Distance between two DAG / CPDAG adjacency matrices}
\usage{
shd(g_true, g_guess)
}
\arguments{
\item{g_true}{Adjacency matrix of the true partially directed acyclic graph}

\item{g_guess}{Adjacency matrix of the guess partially directed acyclic graph}
}
\value{
2-element vector of type double \cr c(normalized error in [0,1], total number of errors)
}
\description{
Computes the structural Hamming distance between the true \code{g_true} PDAG and an estimated \code{g_guess} PDAG.
}
\details{
For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
The source code is available at \href{https://github.com/CausalDisco/gadjid}{github.com/CausalDisco/gadjid}

Graph inputs are accepted as adjacency matrices of type double.
An adjacency matrix for a PDAG may only contain 0s, 1s and 2s.
PDAG are validated for acyclicity.

A \code{1} in row \code{r} and column \code{c} codes a directed edge and
a \code{1} in row \code{c} and column \code{r} codes a directed edge in reverse direction;
a \code{2} in row \code{r} and column \code{c} codes an undirected edge ‘r – c’
(an additional \code{2} in row \code{c} and column \code{r} is ignored;
one of the two entries is sufficient to code an undirected edge).
}
\examples{
full <- rbind(c(0, 1, 1, 1),
              c(0, 0, 1, 1),
              c(0, 0, 0, 1),
              c(0, 0, 0, 0))
chain <- rbind(c(0, 1, 0, 0),
               c(0, 0, 1, 0),
               c(0, 0, 0, 1),
               c(0, 0, 0, 0))
identical(shd(full, chain), c(3/6, 3))

}
