% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{dendrogram_layout}
\alias{dendrogram_layout}
\title{Generate G6 Dendrogram layout configuration}
\usage{
dendrogram_layout(
  direction = c("LR", "RL", "TB", "BT", "H", "V"),
  nodeSep = 20,
  rankSep = 200,
  radial = FALSE,
  ...
)
}
\arguments{
\item{direction}{Character. Layout direction. Options: "LR", "RL", "TB", "BT", "H", "V". Defaults to "LR".}

\item{nodeSep}{Numeric. Node spacing, distance between nodes on the same level. Defaults to 20.}

\item{rankSep}{Numeric. Rank spacing, distance between different levels. Defaults to 200.}

\item{radial}{Logical. Whether to enable radial layout. Defaults to FALSE.}

\item{...}{Additional parameters to pass to the layout.
See \url{https://g6.antv.antgroup.com/en/manual/layout/dendrogram-layout}.}
}
\value{
A list containing the configuration for G6 dendrogram layout.
}
\description{
This function creates a configuration list for G6 Dendrogram layout
with all available options as parameters.
}
