% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.batchtools-package.R
\docType{package}
\name{future.batchtools}
\alias{future.batchtools}
\alias{future.batchtools-package}
\title{future.batchtools: A Future for batchtools}
\description{
The \pkg{future.batchtools} package implements the Future API
on top of \pkg{batchtools} such that futures can be resolved
on for instance high-performance compute (HPC) clusters via
job schedulers.
The Future API is defined by the \pkg{future} package.
}
\details{
To use batchtools futures, load \pkg{future.batchtools}, and
select the type of future you wish to use via
\code{\link[future:plan]{future::plan()}}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(future)
plan(future.batchtools::batchtools_local)
demo("mandelbrot", package = "future", ask = FALSE)
\dontshow{\}) # examplesIf}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://future.batchtools.futureverse.org}
  \item \url{https://github.com/futureverse/future.batchtools}
  \item Report bugs at \url{https://github.com/futureverse/future.batchtools/issues}
}

}
\author{
\strong{Maintainer}: Henrik Bengtsson \email{henrikb@braju.com} (\href{https://orcid.org/0000-0002-7579-5165}{ORCID}) [copyright holder]

}
