% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{felt_get_map_layer_group}
\alias{felt_get_map_layer_group}
\title{Get information for a layer group}
\usage{
felt_get_map_layer_group(map_id, layer_group_id, clean = TRUE)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{layer_group_id}{character, layer group identifier from url, from \code{felt_get_map()}.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
a \link[tibble:tibble]{tibble::tibble} for the layer group, if \code{clean = TRUE}, otherwise a list
}
\description{
Get information for a layer group
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
felt_get_map_layer_group(
  map_id = 'Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA',
  layer_group_id = 'rHxyTef7S9CO8W7n1PvBVwC'
)
\dontshow{\}) # examplesIf}
}
