% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norta.R
\name{rmulti}
\alias{rmulti}
\title{Multiple correlated distributions}
\usage{
rmulti(
  n = 100,
  dist = c(A = "norm", B = "norm"),
  params = list(),
  r = 0,
  empirical = FALSE,
  as.matrix = FALSE
)
}
\arguments{
\item{n}{the number of samples required}

\item{dist}{A named vector of the distributions of each variable}

\item{params}{A list of lists of the arguments to pass to each distribution function}

\item{r}{the correlations among the variables (can be a single number, vars\*vars matrix, vars\*vars vector, or a vars\*(vars-1)/2 vector)}

\item{empirical}{logical. If true, params specify the sample parameters, not the population parameters}

\item{as.matrix}{logical. If true, returns a matrix}
}
\value{
a tbl of vars vectors
}
\description{
Multiple correlated distributions
}
\examples{
dist <- c(A = "norm", 
          B = "pois", 
          C = "binom")
params <- list(A = list(mean = 100, sd = 10),
               B = list(lambda = 5),
               C = list(size = 10, prob = 0.5))
x <- rmulti(100, dist, params, c(0.2, 0.4, 0.6), empirical = TRUE)
get_params(x)
}
