% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norta.R
\name{distfuncs}
\alias{distfuncs}
\title{Get distribution functions}
\usage{
distfuncs(dist = "norm")
}
\arguments{
\item{dist}{The target distribution function (e.g., norm, binom, gamma, truncnorm, likert). If the distribution isn't definited in the packages stats, truncnorm, or faux, use the format "package::dist".}
}
\value{
a list with the r and q functions
}
\description{
Get distribution functions
}
\examples{
qfunc <- distfuncs("norm")$q # returns qnorm
p <- seq(0.1, 0.9, .1)
qfunc(p) == qnorm(p)

rfunc <- distfuncs("norm")$r # returns rnorm
rfunc(n = 10, mean = 100, sd = 10)
}
