% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_void.R
\name{is_void}
\alias{is_void}
\title{is_void(): Check for Null / NA / Blank ("") Values}
\usage{
is_void(x, include_na = TRUE, include_null = TRUE, include_empty_str = TRUE)
}
\arguments{
\item{x}{A vector or list to evaluate.}

\item{include_na}{Logical. Consider \code{NA} as void. Default: TRUE.}

\item{include_null}{Logical. Consider \code{NULL} as void. Default: TRUE.}

\item{include_empty_str}{Logical. Consider \code{""} as void. Default: TRUE.}
}
\value{
A logical vector indicating which elements are void.
\itemize{
\item If \code{x} is \code{NULL}, returns a single \code{TRUE} (if include_null=TRUE) or \code{FALSE}.
\item If \code{x} is an empty vector, returns \code{logical(0)}.
\item If \code{x} is a list, evaluates each element recursively and returns a flattened logical vector.
\item For atomic vectors, returns a logical vector of the same length.
}
}
\description{
Determine whether input values are considered "void": \code{NULL}, \code{NA}, or \code{""}.
Each condition is controlled by a dedicated argument.
}
\examples{
is_void(c(NA, "", "text"))                  # TRUE TRUE FALSE
is_void(list(NA, "", NULL, "a"))            # TRUE TRUE TRUE FALSE
is_void("NA", include_na = FALSE)           # FALSE
is_void(NULL)                               # TRUE
}
