% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.enspls.R
\name{plot.enspls.fs}
\alias{plot.enspls.fs}
\title{Plot enspls.fs object}
\usage{
\method{plot}{enspls.fs}(
  x,
  nvar = NULL,
  type = c("dotplot", "boxplot"),
  limits = c(0, 1),
  main = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{enspls.fs}.}

\item{nvar}{Number of top variables to show. Ignored if \code{sort = FALSE}.}

\item{type}{Plot type, can be \code{"dotplot"} or \code{"boxplot"}.}

\item{limits}{Vector of length 2. Set boxplot limits (in quantile) to
remove the extreme outlier coefficients.}

\item{main}{Plot title, not used currently.}

\item{...}{Additional graphical parameters, not used currently.}
}
\description{
Plot enspls.fs object
}
\examples{
data("logd1k")
x <- logd1k$x
y <- logd1k$y

set.seed(42)
fs <- enspls.fs(x, y, reptimes = 5, maxcomp = 2)
plot(fs, nvar = 10)
plot(fs, type = "boxplot", limits = c(0.05, 0.95), nvar = 10)
}
\seealso{
See \code{\link{enspls.fs}} for measuring feature importance with
ensemble sparse partial least squares regressions.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
