% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiler-apply_recipe.R
\name{EinopsExecutionPlan}
\alias{EinopsExecutionPlan}
\title{Constructor for an Execution Plan (\code{CookedRecipe} in the python sourcecode)}
\usage{
EinopsExecutionPlan(
  init_shapes,
  axes_reordering,
  reduced_axes,
  added_axes,
  final_shapes,
  n_axes_w_added
)
}
\arguments{
\item{init_shapes}{integer vector specifying initial tensor shapes
for reshaping. Length 0 signifies nullness.}

\item{axes_reordering}{integer vector specifying the order for
transposing tensor axes. Length 0 signifies nullness.}

\item{reduced_axes}{List of integers specifying which axes to reduce during
operations. Length 0 signifies nullness.}

\item{added_axes}{\code{\link[r2r:hashtable]{r2r::hashmap()}} mapping axis positions (int) to their
lengths (int) for axes to be added.}

\item{final_shapes}{list of integers specifying final tensor shapes
for reshaping. Length 0 signifies nullness.}

\item{n_axes_w_added}{Integer specifying the total number of axes after
adding new axes.}
}
\value{
An object of class \code{EinopsExecutionPlan}, which is a list containing
the execution plan for transforming tensors according to the specified
recipe.
}
\description{
Constructor for an Execution Plan (\code{CookedRecipe} in the python sourcecode)
}
\keyword{internal}
