% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{counterfactual}
\alias{counterfactual}
\title{Weekly Maxima of Counterfactual Precipitation in Europe}
\format{
A numeric matrix or data frame with dimensions (weeks × stations).
Rows index consecutive winter-season weeks; columns correspond to stations.
Units are millimetres.
}
\usage{
data(counterfactual)
}
\description{
Weekly maxima of precipitation under natural-only forcing over a European domain.
This processed dataset is used in the vignettes and examples to illustrate
model fitting and attribution mapping with eFCM.
}
\details{
This dataset is derived from daily-resolution counterfactual simulations
(not included in the package due to size constraints) by aggregating to weekly
maxima. It is intended for examples, tests, and vignettes where a lightweight
dataset is preferred.
}
\examples{
data(counterfactual)
dim(counterfactual)
plot(apply(counterfactual, 1, mean), type = "l",
     xlab = "Week", ylab = "Mean precipitation (mm)")
}
\keyword{datasets}
