% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_group_modify}
\alias{p_group_modify}
\title{Group-wise modification of data and complex operations}
\usage{
p_group_modify(
  .data,
  ...,
  .messages = NULL,
  .headline = .defaultHeadline(),
  .type = "modify",
  .tag = NULL
)
}
\arguments{
\item{.data}{A grouped tibble}

\item{...}{Additional arguments passed on to \code{.f}
  Named arguments passed on to \code{\link[dplyr:group_map]{dplyr::group_modify}}\describe{
    \item{\code{.f}}{A function or formula to apply to each group.

If a \strong{function}, it is used as is. It should have at least 2 formal arguments.

If a \strong{formula}, e.g. \code{~ head(.x)}, it is converted to a function.

In the formula, you can use
\itemize{
\item \code{.} or \code{.x} to refer to the subset of rows of \code{.tbl}
for the given group
\item \code{.y} to refer to the key, a one row tibble with one column per grouping variable
that identifies the group
}}
\item{\code{.keep}}{are the grouping variables kept in \code{.x}}
}}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, or \{.strata\},\{.count.in\},and \{.count.out\}}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, or \{.strata\},\{.count.in\},and \{.count.out\}}

\item{.type}{default "modify": used to define formatting}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the transformed .data dataframe with the history graph updated.
}
\description{
Group modifying a data set acts in the normal way. The internal mechanics of
the modify function are opaque to the history. This means these can be used
to wrap any unsupported operation without losing the history (e.g. \code{df \%>\% track() \%>\% group_modify(function(d,...) { d \%>\% unsupported_operation() })}
) Prior to the operation the size of the group is calculated \{.count.in\}
and after the operation the output size \{.count.out\} The group \{.strata\}
is also available (if grouped) for reporting See \code{\link[dplyr:group_map]{dplyr::group_modify()}}.
}
\examples{
library(dplyr)
library(dtrackr)

tmp = iris \%>\% track() \%>\% dplyr::group_by(Species)
tmp \%>\% dplyr::group_modify(
      function(d,g,...) { return(tibble::tibble(x=stats::runif(10))) },
      .messages="{.count.in} in, {.count.out} out"
) \%>\% history()
}
\seealso{
\code{\link[dplyr:group_map]{dplyr::group_modify()}}
}
