% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{working_directory}
\alias{working_directory}
\alias{rm_working_directory}
\alias{init_working_directory}
\title{manage docx2pdf working directory}
\usage{
working_directory()

rm_working_directory()

init_working_directory()
}
\description{
Initialize or remove working directory used
when docx2pdf create the PDF.

On 'macOS', the operation require writing rights to the directory by the Word or PowerPoint program.
Word or PowerPoint program must be authorized
to write in the directories, if the authorization does not exist, a
manual confirmation window is launched, thus preventing automation.

Fortunately, users only have to do this once. The package implementation use
only one directory where results are saved in order to have only one
time to click this confirmation.

This directory is managed by R function \code{\link[=R_user_dir]{R_user_dir()}}. Its value can be
read with the \code{working_directory()} function. The directory can be
deleted with \code{rm_working_directory()} and created with \code{init_working_directory()}.
Each call will remove that directory when completed.

As a user, you do not have to use these functions because they are called
automatically by the \code{docx2pdf()} function. They are provided to meet
the requirements of CRAN policy:

\emph{"[...] packages may store user-specific data, configuration and cache files in their respective user
directories [...], provided that by default sizes are kept as small as possible
and the contents are actively managed (including removing outdated material)."}
}
