% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_colgetters.R
\name{colLevels}
\alias{colLevels}
\title{Gives the distinct values of a column of data from the data_frame}
\usage{
colLevels(col, data_frame, rows.use = NULL, used.only = TRUE)
}
\arguments{
\item{col}{quoted column name. the data column whose potential values should be retrieved.}

\item{data_frame}{A data.frame.}

\item{rows.use}{String vector of rows names OR an integer vector specifying the indices of rows which should be included.

Alternatively, a Logical vector, the same length as the number of rows in the data_frame, which indicates which rows to include.}

\item{used.only}{TRUE by default, for target data that are factors, whether levels nonexistent in the target data should be ignored.}
}
\value{
String vector, the distinct values of the \code{col} data column (among the \code{rows.use} targeted rows) of \code{data_frame}.
}
\description{
Gives the distinct values of a column of data from the data_frame
}
\examples{
example("dittoExampleData", echo = FALSE)

colLevels("conditions", example_df)

# Note: Set 'used.only' (default = TRUE) to FALSE to show unused levels
#  of data that are already factors.  By default, only the used options
#  of the data will be given.
colLevels("conditions", example_df,
    rows.use = example_df$conditions!="condition1"
    )
colLevels("conditions", example_df,
    rows.use = example_df$conditions!="condition1",
    used.only = FALSE)
}
\author{
Daniel Bunis
}
