% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods_traversal.R
\name{Do}
\alias{Do}
\title{Executes a function on a set of nodes}
\usage{
# OO-style:
# node$Do(fun, 
#         ..., 
#         traversal = c("pre-order", "post-order", "in-order", "level", "ancestor"), 
#         pruneFun = NULL, 
#         filterFun = NULL)
         
# traditional:
Do(nodes, fun, ...)
}
\arguments{
\item{nodes}{The nodes on which to perform the Get (typically obtained via \code{\link{Traverse}})}

\item{fun}{the function to execute. The function is expected to be either a Method, or to take a 
Node as its first argument}

\item{...}{any additional parameters to be passed on to fun}
}
\description{
Executes a function on a set of nodes
}
\examples{
data(acme)
traversal <- Traverse(acme)
Do(traversal, function(node) node$expectedCost <- node$p * node$cost)
print(acme, "expectedCost")

}
\seealso{
\code{\link{Node}}

\code{\link{Get}}

\code{\link{Set}}

\code{\link{Traverse}}
}
