% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_linear.R
\name{lnormmix}
\alias{lnormmix}
\alias{rlnormmix}
\alias{plnormmix}
\alias{dlnormmix}
\alias{qlnormmix}
\title{Density, Distribution, Quantiles and Random Number Generation for the mixed log-normal
distribution}
\usage{
rlnormmix(n, meanlog, sdlog, prop)

dlnormmix(x, meanlog, sdlog, prop)

plnormmix(q, meanlog, sdlog, prop)

qlnormmix(p, meanlog, sdlog, prop)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rlnormmix()}.}

\item{meanlog}{\link[base]{numeric} \link[base]{vector} holding the means
of the components on the log scale.}

\item{sdlog}{\link[base]{numeric} \link[base]{vector} holding the standard
deviations of the components on the log scale.}

\item{prop}{\link[base]{numeric} \link[base]{vector}, holding the mixing proportions
of the components.}

\item{x}{\link[base]{numeric} \link[base]{vector} giving the points where
the density function is evaluated.}

\item{q}{\link[base]{numeric} \link[base]{vector} giving the quantiles where
the distribution function is evaluated.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\itemize{
\item \code{dlnormmix()} gives a \link[base]{vector} of length \code{length(x)}
 containing the density at \code{x}.
\item \code{plnormmix()} gives a
\link[base]{vector} of length \code{length(q)} containing
the distribution function at the corresponding values of \code{q}.
\item \code{qlnormmix()} gives a \link[base]{vector} of length \code{length(p)}
containing the quantiles at the corresponding values of \code{p}.
\item \code{rlnormmix()} generates a \link[base]{vector} of length \code{n}
containing the random samples.
}
}
\description{
The number of components in the mixed log-normal distribution is specified by the length
of the parameter vectors. The quantiles are numerically obtained from the distribution function using
monotone cubic splines.
}
\examples{

rlnormmix(10, meanlog = c(1, 3, 7), sdlog = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

dlnormmix(c(0, 2, 1), meanlog = c(1, 3), sdlog = c(2, 2), prop = c(0.6, 0.4))

prob <- plnormmix(c(0.1, 7), meanlog = c(1, 3, 7), sdlog = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))
prob
qlnormmix(prob, meanlog = c(1, 3, 7), sdlog = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

}
