% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_tag}
\alias{set_tag}
\title{Set a tag}
\usage{
set_tag(x, tag)
}
\arguments{
\item{x}{(vector of) \link{scenario} objects}

\item{tag}{(vector of) \code{character} or any other object}
}
\value{
(vector of) modified \link{scenarios}
}
\description{
Sets the user-defined, custom tag of a scenario. Tags
can be helpful to quickly distinguish scenarios by e.g. a user-specified
string.
}
\details{
The function supports vectorized inputs.
If arguments \code{x} and \code{tag} are vectors, then tags are assigned to scenarios
on a 1:1 basis. If the length of both vectors do not match, an error is raised.
}
\examples{
# set a custom tag
myscenario <- GUTS_RED_SD() \%>\% set_tag("My Custom Tag")

# returns `My Custom Tag`
get_tag(myscenario)

# the tag also appears in the scenario overview
myscenario
}
\seealso{
\code{\link[=get_tag]{get_tag()}}
}
