% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_meta.R
\name{cso_get_interval}
\alias{cso_get_interval}
\title{Returns a the time interval used to record data in a CSO table}
\usage{
cso_get_interval(table_code, cache = FALSE, flush_cache = TRUE)
}
\arguments{
\item{table_code}{string. A valid code for a table on data.cso.ie .}

\item{cache}{logical. Whether to use cached data, if available.
Default value is FALSE.}

\item{flush_cache}{logical. If TRUE (default) the cache will be checked for old, unused
files. Any files which have not been accessed in the last month will be deleted}
}
\value{
character vector. The names of the statistics included in the
table, with one element for each statistic.
}
\description{
Reads the metadata of a table to return an atomic character vector
displaying the intervals at which the data included in the table was
gathered/calculated.
}
\examples{
\dontrun{
interval <- cso_get_interval("C0636")
}
}
