% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\docType{data}
\name{MSIS}
\alias{MSIS}
\alias{winkler_score}
\alias{interval_measures}
\title{Interval estimate accuracy measures}
\format{
An object of class \code{list} of length 2.
}
\usage{
MSIS(
  lower,
  upper,
  actual,
  train,
  level = 95,
  period,
  d = period == 1,
  D = period > 1,
  na.rm = TRUE,
  ...
)

winkler_score(lower, upper, actual, level = 95, na.rm = TRUE, ...)

interval_measures
}
\arguments{
\item{lower}{A numeric vector of lower bounds of interval forecasts.}

\item{upper}{A numeric vector of upper bounds of interval forecasts.}

\item{actual}{A numeric vector of realised values.}

\item{train}{A numeric vector of responses used to train the model (for scaled scores).}

\item{level}{The nominal level of the forecast interval (e.g., 95 or 0.95).}

\item{period}{The seasonal period of the data.}

\item{d}{Should the response model include a first difference?}

\item{D}{Should the response model include a seasonal difference?}

\item{na.rm}{If \code{TRUE}, remove missing values before calculating the measure.}

\item{...}{Additional arguments for each measure.}
}
\value{
For \code{winkler_score} and \code{MSIS}, returns a single numeric scalar giving
the average interval score (Winkler or mean scaled interval score).

For the exported object \code{interval_measures}, returns a \strong{named list of functions}
that can be supplied to higher-level accuracy routines.
}
\description{
Accuracy measures for interval forecasts.
}
\examples{
set.seed(1)
actual <- rnorm(10)
lower  <- actual - runif(10, 0.5, 1)
upper  <- actual + runif(10, 0.5, 1)
train  <- rnorm(50)

# Winkler score at 95\%
winkler_score(lower, upper, actual, level = 95)

# Mean scaled interval score (needs training data and period)
MSIS(lower, upper, actual, train, level = 95, period = 1)

}
\keyword{datasets}
