% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\alias{print.coverage}
\title{Calculate interval forecast coverage}
\usage{
coverage(object, ..., level = 95, window = NULL, na.rm = FALSE)
}
\arguments{
\item{object}{An object of class \code{"cvforecast"} or \code{"cpforecast"}.}

\item{...}{Additional inputs if \code{object} is missing.}

\item{level}{Target confidence level for prediction intervals.}

\item{window}{If not \code{NULL}, the rolling mean matrix for coverage is also returned.}

\item{na.rm}{A logical indicating whether \code{NA} values should be stripped
before the rolling mean computation proceeds.}
}
\value{
A list of class \code{"coverage"} with the following components:
\item{mean}{Mean coverage across the validation set.}
\item{ifinn}{A indicator matrix as a multivariate time series, where the \eqn{h}th column
holds the coverage for forecast horizon \eqn{h}. The time index
corresponds to the period for which the forecast is produced.}
\item{rollmean}{If \code{window} is not NULL, a matrix of the rolling means
of interval forecast coverage will be returned.}
}
\description{
Calculate the mean coverage and the ifinn matrix for prediction intervals on
validation set. If \code{window} is not \code{NULL}, a matrix of the rolling
means of interval forecast coverage is also returned.
}
\examples{
# Simulate time series from an AR(2) model
library(forecast)
series <- arima.sim(n = 200, list(ar = c(0.8, -0.5)), sd = sqrt(1))

# Cross-validation forecasting with a rolling window
far2 <- function(x, h, level) {
  Arima(x, order = c(2, 0, 0)) |>
    forecast(h = h, level)
}
fc <- cvforecast(series, forecastfun = far2, h = 3, level = 95,
                 forward = TRUE, initial = 1, window = 50)

# Mean and rolling mean coverage for interval forecasts on validation set
cov_fc <- coverage(fc, level = 95, window = 50)
str(cov_fc)

}
