\name{pecarn_rule_febrile_infant_29_60_days}
\alias{pecarn_rule_febrile_infant_29_60_days}
\title{
PECARN Rule for Low-Risk Febrile Infants (29-60 Days)
}
\description{
Applies the PECARN clinical prediction rule to identify febrile infants aged 29-60 days who are at very low risk for serious bacterial infections (SBI), including bacteremia, bacterial meningitis, and urinary tract infection. The rule uses three objective laboratory criteria.
}
\usage{
pecarn_rule_febrile_infant_29_60_days(urinalysis_positive,
                                        absolute_neutrophil_count, procalcitonin)
}
\arguments{
  \item{urinalysis_positive}{
Numeric (0 or 1). Is the urinalysis positive? Defined as positive leukocyte esterase, nitrite, or >5 WBC/hpf. (1 = Yes).
}
  \item{absolute_neutrophil_count}{
Numeric. The absolute neutrophil count (ANC) in cells/uL or /mm^3. (Low risk threshold: <= 4090).
}
  \item{procalcitonin}{
Numeric. Serum procalcitonin level in ng/mL. (Low risk threshold: <= 1.71).
}
}
\details{
The rule identifies infants as **Low Risk** if:
\itemize{
  \item Urinalysis is negative
  \item Absolute Neutrophil Count (ANC) \eqn{\le} 4090 cells/\eqn{\mu}L
  \item Serum Procalcitonin \eqn{\le} 1.71 ng/mL
}
In the derivation/validation study, the sensitivity for SBI was very high (approx. 97.7-99.8\%), with a high negative predictive value. It is specifically validated for well-appearing infants 29-60 days old with fever.
}
\value{
A list containing:
\item{Risk_Classification}{"Low Risk" or "Not Low Risk".}
\item{Recommendation}{Clinical guidance regarding the need for further workup (e.g., LP) and admission.}
}
\references{
Kuppermann N, Dayan PS, Levine DA, et al. A Clinical Prediction Rule to Identify Febrile Infants 60 Days and Younger at Low Risk for Serious Bacterial Infections. JAMA Pediatr. 2019;173(4):342-351. doi:10.1001/jamapediatrics.2018.5501
}
\examples{

# Example 1: Low Risk
# Neg UA, ANC 3000, PCT 0.2
pecarn_rule_febrile_infant_29_60_days(0, 3000, 0.2)

# Example 2: High Risk (Positive UA)
# Pos UA (1), ANC 3000, PCT 0.2
pecarn_rule_febrile_infant_29_60_days(1, 3000, 0.2)

# Example 3: High Risk (High PCT)
# Neg UA, ANC 3000, PCT 2.0
pecarn_rule_febrile_infant_29_60_days(0, 3000, 2.0)
}
