\name{delta_p_lems_score}
\alias{delta_p_lems_score}
\title{
Dutch-English LEMS Tumor Association Prediction (DELTA-P) Score
}
\description{
Calculates the DELTA-P score to predict the likelihood of Small Cell Lung Cancer (SCLC) in patients with Lambert-Eaton Myasthenic Syndrome (LEMS). The score assigns 1 point for each of six risk factors present at diagnosis: Bulbar weakness, Erectile dysfunction (in males), Weight loss >= 5\%, Tobacco use at onset, Age at onset >= 50 years, and Karnofsky Performance Status < 70.
}
\usage{
delta_p_lems_score(bulbar_weakness, erectile_dysfunction_male,
                   weight_loss_ge_5pct, tobacco_at_onset, age_onset_ge_50,
                   kps_lt_70)
}
\arguments{
  \item{bulbar_weakness}{
Numeric (0 or 1). Presence of dysarthria, dysphagia, chewing weakness, or neck weakness. (1 = Yes).
}
  \item{erectile_dysfunction_male}{
Numeric (0 or 1). Presence of erectile dysfunction in a male patient. (1 = Yes, 0 = No/Female).
}
  \item{weight_loss_ge_5pct}{
Numeric (0 or 1). Weight loss of 5\% or more. (1 = Yes).
}
  \item{tobacco_at_onset}{
Numeric (0 or 1). Smoking at the time of LEMS onset. (1 = Yes).
}
  \item{age_onset_ge_50}{
Numeric (0 or 1). Age at onset of symptoms >= 50 years. (1 = Yes).
}
  \item{kps_lt_70}{
Numeric (0 or 1). Karnofsky Performance Status < 70 (0-60). (1 = Yes).
}
}
\value{
A list containing:
\item{DELTA_P_Score}{The calculated score (Range 0-6).}
\item{SCLC_Probability}{Estimated percentage probability of having SCLC.}
}
\references{
Titulaer MJ, Maddison P, Sont JK, et al. Clinical Dutch-English Lambert-Eaton myasthenic syndrome (LEMS) tumor association prediction score accurately predicts small-cell lung cancer in the LEMS. J Clin Oncol. 2011;29(7):902-908. doi:10.1200/JCO.2010.32.0440
}
\examples{

# Example 1: Low Risk
# Young female, non-smoker, no weight loss
# Score = 0
delta_p_lems_score(0, 0, 0, 0, 0, 0)

# Example 2: High Risk
# 60yo Male, Smoker, Erectile Dysfunction, Wt Loss
# Score = 1 (Age) + 1 (Sex/ED) + 1 (Wt) + 1 (Smoke) = 4
delta_p_lems_score(0, 1, 1, 1, 1, 0)
}
