% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{generate_ratings}
\alias{generate_ratings}
\title{A Tool for Rating Text/Image Stimuli}
\usage{
generate_ratings(
  model = "gpt-4-turbo",
  stim,
  prompt = "You are an expert rater, limit your answer to numbers.",
  question = "Please rate this:",
  scale = "1-7",
  top_p = 1,
  temp = 0,
  n_iterations = 1,
  api_key = "",
  debug = TRUE
)
}
\arguments{
\item{model}{LLM model name (default: 'gpt-4-turbo')}

\item{stim}{Input stimulus (text string and image URL)}

\item{prompt}{System instruction for the LLM}

\item{question}{Specific rating question for the LLM}

\item{scale}{Rating scale range (default: '1-7')}

\item{top_p}{Top-p sampling parameter (default: 1)}

\item{temp}{Temperature parameter (default: 0)}

\item{n_iterations}{Number of rating iterations (default: 1)}

\item{api_key}{OpenAI API key}

\item{debug}{Debug mode flag (default: FALSE)}
}
\value{
A data frame containing ratings and metadata
}
\description{
Evaluates stimuli using Large Language Models APIs with URL support.
}
